#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct pont {
    int x, y;
    pont(int x = 0, int y = 0) : x(x), y(y) {}
    bool operator < (const pont& p) const {
        return (x == p.x) ? (y < p.y) : (x < p.x);
    }
};
int cp(const pont& o, const pont& a, const pont& b) {
    return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
}
vector<pont> graham_scan(vector<pont>& pontok) {
    sort(pontok.begin(), pontok.end());
    vector<pont> also;
    for (const pont& p : pontok) {
        while (also.size() >= 2 && cp(also[also.size() - 2], also[also.size() - 1], p) <= 0) {
            also.pop_back();
        }
        also.push_back(p);
    }
    vector<pont> felso;
    for (int i = pontok.size() - 1; i >= 0; --i) {
        while (felso.size() >= 2 && cp(felso[felso.size() - 2], felso[felso.size() - 1], pontok[i]) <= 0) {
            felso.pop_back();
        }
        felso.push_back(pontok[i]);
    }
    also.pop_back();
    felso.pop_back();
    also.insert(also.end(), felso.begin(), felso.end());
    return also;
}
double shterulet(const vector<pont>& abra) {
    int n = abra.size();
    double area = 0;
    for(int i=0;i<n;++i) {
        int j =(i+1)%n;
        area +=abra[i].x*abra[j].y-abra[i].y*abra[j].x;
    }
    return abs(area)/2.0;
}

int main() {
    int N;
    cin >> N;
    vector<pont> pontok(N);
    for(int i=0;i<N;++i){
        cin>>pontok[i].x >> pontok[i].y;
    }
    vector<pont> convex_hull = graham_scan(pontok);
    double terulet=shterulet(convex_hull);
    cout << static_cast<int>(round(terulet)) << endl;
    return 0;
}